function [shaftSpd, shaftTrq, gbPrf] = gearboxModel(fdSpd, fdTrq, GN, gb)

%% Gearbox
GNpos = GN(GN > 0);

spdRatio = ones(size(GN));
spdRatio(GN > 0) = [gb.gear(GNpos).spdRatio];
spdRatio(GN == 0,:) = 1;

% Crankshaft speed (rad/s)
shaftSpd  = spdRatio .* fdSpd;

% Losses
switch gb.lossMethod
    case 'eff'
        % Gearbox efficiency (-)
        gbEff = zeros(size(GNpos));
        gbEff(:) = [gb.gear(GNpos).eff];

        % Traction
        lossTrq_engaged = ( 1 - gbEff ) ./ gbEff ./ spdRatio .* fdTrq;
        % Braking
        gbEff = gbEff.*ones(size(fdTrq));
        lossTrq_engaged( fdTrq < 0 ) = ( 1 - gbEff( fdTrq < 0 ) ) .* fdTrq( fdTrq < 0 );

    case 'trqLossMap'
        fdSpd = fdSpd.*ones(size(fdTrq));
        if isscalar(GNpos)
            lossTrq_engaged = gb.gear(GNpos).trqLossMap(fdSpd, fdTrq);
        else
            lossTrq_engaged = arrayfun(@(x) x.trqLossMap(fdSpd, fdTrq), gb.gear(GNpos));
            lossTrq_engaged = lossTrq_engaged(:);
        end
        
end

shaftSpd(GN == 0, :) = 0;
lossTrq(GN == 0, :) = 0;
lossTrq(GN > 0, :) = lossTrq_engaged;

% Crankshaft torque (Nm)
% lossTrq is referred to the gearbox input
shaftTrq  = fdTrq ./ spdRatio + lossTrq;

%% Pack additional outputs
gbPrf.gbSpd = shaftSpd;
gbPrf.gbTrq = shaftTrq;
gbPrf.gbLossTrq = lossTrq;
gbPrf.gearNumber = GN;


